﻿
using System;
using System.Collections.Generic;
using System.Text;
using Gemini.Core.BL.Interface.DBD;

namespace PI.ZB.N1200.ELearning.BL.DBD.View
{
    internal class StatisticStudent : PI.FM.N000.Base.BL.DBD.BaseTable<BO.View.StatisticStudent>
    {
        #region Static factory
        private static StatisticStudent _factory = null;

        public static StatisticStudent DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new StatisticStudent();
                }
                return _factory;
            }
        }
        #endregion

        #region Override - Initialization
        protected override void InitializeTableName()
        {
            _tableName = "PIZB1200_StudentStatisticView";
        }

        protected override void InitializeProperties()
        {
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("ClassID", "ClassID"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Forename", "Forename"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Surename", "Surename"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("ClassName", "ClassName"));

            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CompetencePointsByWeight", "CompetencePointsByWeight"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CompetenceMaxPoints", "CompetenceMaxPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CaseStudyPoints", "CaseStudyPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CaseStudyMaxPoints", "CaseStudyMaxPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("AdvancedTestStartPoints", "AdvancedTestStartPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("AdvancedTestStartMaxPoints", "AdvancedTestStartMaxPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("AdvancedTestEndPoints", "AdvancedTestEndPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("AdvancedTestEndMaxPoints", "AdvancedTestEndMaxPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("KnowledgeTestStartPoints", "KnowledgeTestStartPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("KnowledgeTestStartMaxPoints", "KnowledgeTestStartMaxPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("KnowledgeTestEndPoints", "KnowledgeTestEndPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("KnowledgeTestEndMaxPoints", "KnowledgeTestEndMaxPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.DecimalProperty("Salary", "Salary"));
            Add(new PI.FM.N000.Base.BL.DBD.DecimalProperty("GameCash", "GameCash"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("ResetCount", "ResetCount"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CompetencePartDone", "CompetencePartDone"));
        }
        #endregion

        #region Commands definition
        public enum Commands
        {
            RestoreBySearch = 10,
        }
        #endregion

        #region Get Commands
        protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
        {
            switch (CommandID)
            {
                case (int)Commands.RestoreBySearch: return new Command_RestoreBySearch();
            }

            return base.DoGetCommand(CommandID);
        }
        #endregion

        #region Additional Commands Classes
        class Command_RestoreBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.View.StatisticStudent>
        {
            public Command_RestoreBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.View.StatisticStudent.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("StudentID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("ClassID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("InstructorID", Gemini.Core.BL.DAL.SqlTypes.BigInt));                
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_StudentStatisticView_RestoreBySearch";
            }
        }
        #endregion
    }
}